//script made with GST-Builder from www.gstools.de
//------------------------------------------------------------------
// Name: GSTsqlite
// Creator: nfs42 gstools.de
// purpose: functions for GSTsqlite.dll, a database plugin based on sqlite
//          for 3DGS 6.xx 
//------------------------------------------------------------------
// version: 1.3.0 official   2010-08-01
//          + ExecuteQueryAsThread
//  				compiled with sqlite 3.2.7
// version: 1.2.0 official   2009-11-20
//          x _CreateRow now STRING* parameters !
//          x _UpdateRow now STRING* parameters !
// version: 1.1.0 official   2008-12-07
//          - _UpdateValues replaced by
//          + _CreateRow
//          - _UpdateValues replaced by
//          + _UpdateRow
// version: 1.0.0 official   2008-05-22
// version: 0.3.2 beta   2007-09-08
//     handles for db and query functions
// version: 0.3 beta   2007-06-28
//     first lite-c version
// version: 0.2 beta   2007-06-28
//     initial release
//------------------------------------------------------------------

function GSTsqlite_OpenDatabase(STRING* dbname);  			// opens a file database SQLite 3.x
function GSTsqlite_CloseDatabase(var vhndDB);       		// close database
function GSTsqlite_ExecuteQuery(var vhndDB, STRING* sql);// returns a valid query handle or 0
function GSTsqlite_ExecuteQueryAsThread(var vhndDB, STRING* sql);// returns a valid query handle or 0
function GSTsqlite_Debug(var vMode);
function GSTsqlite_CloseQuery(var vhndQuery);
function GSTsqlite_NextRow(var vhndQuery);
function GSTsqlite_EOF(var vhndQuery);
function GSTsqlite_GetString(var vhndQuery, STRING* field, STRING* value);
function GSTsqlite_GetFloat(var vhndQuery, STRING* field, var* value);
function GSTsqlite_GetInteger(var vhndQuery, STRING* field, var* value);
function GSTsqlite_Version(STRING* sVersion);
function GSTsqlite_QueryBusy(var vhndQuery);


// bind files used by the DLL to the project
//bind "GSTsqlite.dll";

var GSTsqlite_hndDB;   // standard handle
var GSTsqlite_hndQ;    // standard handle
STRING* GSTsqlite_StringResult[256];
var GSTsqlite_VarResult;
int bGSTsqlite_QueryBusy;
STRING* sGSTsqliteTemp = "";


//------------------------------------------------------------------
// GSTsqlite_CreateRow
// purpose: create a new row or replace a still created row with defaults
// if a field is a primary key and is not in the table yet
// a row is added an the values are stored in this row  
// input: string table   tablename
// input: string fields: fieldnames seperated by comma
// input: string values: values seperated by comma
//------------------------------------------------------------------
var GSTsqlite_CreateRow(STRING* table, STRING* fields, STRING* values) {
  
  str_cpy(sGSTsqliteTemp,"REPLACE INTO ");
  str_cat(sGSTsqliteTemp,table);
  str_cat(sGSTsqliteTemp," (");
  str_cat(sGSTsqliteTemp,fields);
  str_cat(sGSTsqliteTemp,") VALUES (");
  str_cat(sGSTsqliteTemp,values);
  str_cat(sGSTsqliteTemp,");");
  
  return(GSTsqlite_ExecuteQueryAsThread(GSTsqlite_hndDB, sGSTsqliteTemp));

}

//------------------------------------------------------------------
// GSTsqlite_UpdateRow
// purpose: updates one field in rows selected by where-statement  
// input: string table   tablename
// input: string where:  sql where-statement
// input: string fields: fieldname
// input: string values: value
//------------------------------------------------------------------
var GSTsqlite_UpdateRow(STRING* table, STRING* where, STRING* field, STRING* value) {

  str_cpy(sGSTsqliteTemp,"UPDATE ");
  str_cat(sGSTsqliteTemp,table);
  str_cat(sGSTsqliteTemp," SET ");
  str_cat(sGSTsqliteTemp,field);
  str_cat(sGSTsqliteTemp,"=");
  str_cat(sGSTsqliteTemp,value);
  str_cat(sGSTsqliteTemp," WHERE ");
  str_cat(sGSTsqliteTemp,where);
  str_cat(sGSTsqliteTemp,";");
  
  return(GSTsqlite_ExecuteQuery(GSTsqlite_hndDB, sGSTsqliteTemp));
}
